/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.core.terminal.Palette;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import net.minecraft.class_2487;

public class NetworkedTerminal
extends Terminal {
    public NetworkedTerminal(int width, int height, boolean colour) {
        super(width, height, colour);
    }

    public NetworkedTerminal(int width, int height, boolean colour, Runnable changedCallback) {
        super(width, height, colour, changedCallback);
    }

    synchronized TerminalState write() {
        byte[] contents = new byte[this.width * this.height * 2 + 48];
        int idx = 0;
        for (int y = 0; y < this.height; ++y) {
            int x;
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (x = 0; x < this.width; ++x) {
                contents[idx++] = (byte)(text.charAt(x) & 0xFF);
            }
            for (x = 0; x < this.width; ++x) {
                contents[idx++] = (byte)(NetworkedTerminal.getColour(backColour.charAt(x), Colour.BLACK) << 4 | NetworkedTerminal.getColour(textColour.charAt(x), Colour.WHITE));
            }
        }
        for (int i = 0; i < 16; ++i) {
            for (double channel : this.palette.getColour(i)) {
                contents[idx++] = (byte)((int)(channel * 255.0) & 0xFF);
            }
        }
        assert (idx == contents.length);
        return new TerminalState(this.colour, this.width, this.height, this.cursorX, this.cursorY, this.cursorBlink, this.cursorColour, this.cursorBackgroundColour, contents);
    }

    synchronized void read(TerminalState state) {
        this.resize(state.width, state.height);
        this.cursorX = state.cursorX;
        this.cursorY = state.cursorY;
        this.cursorBlink = state.cursorBlink;
        this.cursorBackgroundColour = state.cursorBgColour;
        this.cursorColour = state.cursorFgColour;
        byte[] contents = state.contents;
        int idx = 0;
        for (int y = 0; y < this.height; ++y) {
            int x;
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (x = 0; x < this.width; ++x) {
                text.setChar(x, (char)(contents[idx++] & 0xFF));
            }
            for (x = 0; x < this.width; ++x) {
                byte colour = contents[idx++];
                backColour.setChar(x, "0123456789abcdef".charAt(colour >> 4 & 0xF));
                textColour.setChar(x, "0123456789abcdef".charAt(colour & 0xF));
            }
        }
        for (int i = 0; i < 16; ++i) {
            double r = (double)(contents[idx++] & 0xFF) / 255.0;
            double g = (double)(contents[idx++] & 0xFF) / 255.0;
            double b = (double)(contents[idx++] & 0xFF) / 255.0;
            this.palette.setColour(i, r, g, b);
        }
        assert (idx == contents.length);
        this.setChanged();
    }

    public synchronized class_2487 writeToNBT(class_2487 nbt) {
        nbt.method_10569("term_cursorX", this.cursorX);
        nbt.method_10569("term_cursorY", this.cursorY);
        nbt.method_10556("term_cursorBlink", this.cursorBlink);
        nbt.method_10569("term_textColour", this.cursorColour);
        nbt.method_10569("term_bgColour", this.cursorBackgroundColour);
        for (int n = 0; n < this.height; ++n) {
            nbt.method_10582("term_text_" + n, this.text[n].toString());
            nbt.method_10582("term_textColour_" + n, this.textColour[n].toString());
            nbt.method_10582("term_textBgColour_" + n, this.backgroundColour[n].toString());
        }
        int[] rgb8 = new int[16];
        for (int i = 0; i < 16; ++i) {
            rgb8[i] = Palette.encodeRGB8(this.palette.getColour(i));
        }
        nbt.method_10539("term_palette", rgb8);
        return nbt;
    }

    public synchronized void readFromNBT(class_2487 nbt) {
        int[] rgb8;
        this.cursorX = nbt.method_10550("term_cursorX");
        this.cursorY = nbt.method_10550("term_cursorY");
        this.cursorBlink = nbt.method_10577("term_cursorBlink");
        this.cursorColour = nbt.method_10550("term_textColour");
        this.cursorBackgroundColour = nbt.method_10550("term_bgColour");
        for (int n = 0; n < this.height; ++n) {
            this.text[n].fill(' ');
            if (nbt.method_10545("term_text_" + n)) {
                this.text[n].write(nbt.method_10558("term_text_" + n));
            }
            this.textColour[n].fill("0123456789abcdef".charAt(this.cursorColour));
            if (nbt.method_10545("term_textColour_" + n)) {
                this.textColour[n].write(nbt.method_10558("term_textColour_" + n));
            }
            this.backgroundColour[n].fill("0123456789abcdef".charAt(this.cursorBackgroundColour));
            if (!nbt.method_10545("term_textBgColour_" + n)) continue;
            this.backgroundColour[n].write(nbt.method_10558("term_textBgColour_" + n));
        }
        if (nbt.method_10545("term_palette") && (rgb8 = nbt.method_10561("term_palette")).length == 16) {
            for (int i = 0; i < 16; ++i) {
                double[] colours = Palette.decodeRGB8(rgb8[i]);
                this.palette.setColour(i, colours[0], colours[1], colours[2]);
            }
        }
        this.setChanged();
    }
}

